
IF OBJECT_ID('P_EXP_CTB_MOV_VENDAS_CONTABIL_IMPOSTOS') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_IMPOSTOS
	END
 
GO --exec P_EXP_CTB_MOV_VENDAS_CONTABIL_IMPOSTOS 1,23,'20210216','20210216'
 
CREATE PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_IMPOSTOS(@CD_EMP		INT,
													    @CD_FILIAL	INT,
													    @DT_INI		DATETIME,
													    @DT_FIM		DATETIME,
													    @FLAG_LIMPAR INT = 0)		
	

WITH ENCRYPTION AS  
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	
	DECLARE @RS_CD_EMP				       INT
	DECLARE @RS_CD_FILIAL			       INT 
	DECLARE @RS_DT_MOV				       DATETIME
	DECLARE @RS_CD_SC				       INT
	DECLARE @RS_DS_SC				       VARCHAR(100)
	DECLARE @RS_CD_CTB_CNT_RED		       VARCHAR(50)
	DECLARE @RS_CD_CTB_CNT			       VARCHAR(50)
	DECLARE @RS_VLR_VD				       MONEY
	DECLARE @RS_VLR_ICMS			       MONEY
	DECLARE @RS_VLR_BASE_PIS_COFINS        MONEY
	DECLARE @RS_RECARGA_DINH               MONEY
	DECLARE @RS_RECARGA_CARTAO             MONEY
	DECLARE @RS_RECARGA_CHQ                MONEY
	DECLARE @RS_VLR_SERVICO                MONEY
	DECLARE @RS_VLR_LINX_PROMO_N_FISCAL    MONEY 
	DECLARE @RS_VLR_LINX_PROMO_FISCAL      MONEY 
	DECLARE @RS_RECEB_TERCEIROS_DINH       MONEY
	DECLARE @RS_RECEB_TERCEIROS_CARTAO     MONEY
	DECLARE @RS_RECEB_RPS_DINH             MONEY
	DECLARE @RS_RECEB_RPS_CARTAO           MONEY
	
	DECLARE @RET_CD_CTB_CNT			 VARCHAR(100)
	DECLARE @RET_CD_CTB_CNT_RED		 INT	
	DECLARE @RET_DS_CNT				 VARCHAR(100)
	DECLARE @RET_NR_CNT				 VARCHAR(50)
	DECLARE @RET_TP_CNT				 INT
	DECLARE @RET_TITULAR_CNT		 VARCHAR(200)
    DECLARE @RET_RZ_CLI				 VARCHAR(200)
    								 
    DECLARE @MOVIMENTO				 VARCHAR(50)
    DECLARE @OPERACAO				 VARCHAR(50)
    DECLARE @OPERACAO_DEBITO		 VARCHAR(50)
    DECLARE @HIST					 VARCHAR(250)
									 
	DECLARE @CD_CNT_RED_CREDITO		 INT
	DECLARE @CD_CNT_CREDITO			 VARCHAR(20)
	DECLARE @CD_CNT_RED_DEBITO		 INT
	DECLARE @CD_CNT_DEBITO			 VARCHAR(20)	
    								 
    DECLARE @PERC_COFINS			 MONEY
    DECLARE @PERC_PIS				 MONEY
    
    DECLARE @VLR_COFINS				 MONEY
    DECLARE @VLR_PIS				 MONEY
	DECLARE @NR_CONTROLE			 VARCHAR (12)
    
    SET @PERC_COFINS = ISNULL((SELECT TOP 1 PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 2),0)
	SET @PERC_PIS    = ISNULL((SELECT TOP 1 PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 1),0)
     
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR		
	 	 
	DECLARE RS_RESULT
	CURSOR FOR 								
		SELECT 
			T.CD_EMP				, 
			T.CD_FILIAL				, 
			T.DT_VD					,
			T.CD_SC					,
			T.DS_SC					,
			T.CD_CTB_CNT_RED		,
			T.CD_CTB_CNT			,
			T.VLR_VD				,
			T.VLR_ICMS				,
			T.VLR_BASE_PIS_COFINS, 
			T.RECARGA_DINH,
			T.RECARGA_CARTAO,
			T.RECARGA_CHQ,
			T.VLR_SERVICO,
			T.VLR_LINX_PROMO_N_FISCAL,
			T.VLR_LINX_PROMO_FISCAL,
			T.RECEB_TERCEIROS_DINH,
			T.RECEB_TERCEIROS_CARTAO,
			T.RECEB_RPS_DINH, 
			T.RECEB_RPS_CARTAO
		FROM
		    -- SELECT * FROM UFD_EXP_CTB_MOV_VENDA_SECAO(1, 23, '20210216', '20210216') T 
		    UFD_EXP_CTB_MOV_VENDA_SECAO(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM) T
			
		ORDER BY 
			T.CD_EMP,
			T.CD_FILIAL,		
			T.DT_VD

		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
				@RS_CD_EMP, 
				@RS_CD_FILIAL,						
				@RS_DT_MOV,
				@RS_CD_SC,
				@RS_DS_SC,
				@RS_CD_CTB_CNT_RED,
				@RS_CD_CTB_CNT,
				@RS_VLR_VD,
				@RS_VLR_ICMS,
				@RS_VLR_BASE_PIS_COFINS,
				@RS_RECARGA_DINH,
				@RS_RECARGA_CARTAO,
				@RS_RECARGA_CHQ,
				@RS_VLR_SERVICO,
				@RS_VLR_LINX_PROMO_N_FISCAL,
				@RS_VLR_LINX_PROMO_FISCAL,
				@RS_RECEB_TERCEIROS_DINH,
				@RS_RECEB_TERCEIROS_CARTAO,
				@RS_RECEB_RPS_DINH,
				@RS_RECEB_RPS_CARTAO
								

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
				------------------------------------------------------------------------------------------------------------------
				--VENDAS CREDITO - Ctb_Cnt_Movimento_Vendas 
				------------------------------------------------------------------------------------------------------------------					
				SET @HIST = 'VALOR REF. VENDAS N/ DATA CONF. CUPONS FISCAIS'
				SET @HIST = REPLACE (@HIST,'	',' ')
				--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
				--1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
				--2 - vendas icms
				--3 - vendas confins 
				--4 - vendas pis 
				--5 - vendas custo
				
								
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
			    --===========================================================================================================================	
				
				INSERT INTO ##CTB_EXP_MOV 
				
						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
 
						SELECT									   
									@RS_CD_EMP					,							--CD_EMP
									@CD_FILIAL					,							--CD_FILIAL_EXPORT
									@RS_CD_FILIAL				,								--CD_FILIAL
									2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
									'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
									'VENDAS - CREDITO'			,								--OPERACAO
									''							,							--OPERACAO_DEBITO                					
									0							,							--CD_CNT_RED_CREDITO
									''							,							--CD_CNT_CREDITO
									0							,							--CD_CNT_RED_DEBITO
									''							,							--CD_CNT_DEBITO								
									@RS_DT_MOV					,							--DT_MOV
									@HIST						,							--HIST
									ROUND(@RS_VLR_VD + @RS_VLR_SERVICO,2)			,				--VLR_LANC
									'C'							,							--TP_TRANSA
									0 			,											--RATEIO_CENTRO_CUSTO
									'' 			,											--DS_CENTRO_CUSTO
									0 			,											--CNT_CENTRO_CUSTO
									0 			,											--VLR_CENTRO_CUSTO											
									'FILIAIS'  ,												--ORIG_CONTA
									13			,											--COD_CONTA
									OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
									,'C' AS TIPO_LANCTO
								    , 0 AS CD_EVENTO
								    , 0  AS NR_DP
								    , 0  AS ANO
								    , @NR_CONTROLE AS NR_DOC
								    , '' AS CD_BC_LANC;
				
				IF ROUND(@RS_VLR_ICMS,2) > 0
					BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO - Ctb_Cnt_Movimento_Icms_Recolher 
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. ICMS/VENDAS N/ DATA CONF. CUPONS FISCAIS'
						SET @HIST = REPLACE (@HIST,'	',' ')

					   --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
					   --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
					   --2 - vendas icms
					   --3 - vendas confins 
					   --4 - vendas pis 
					   --5 - vendas custo
				
								
					   SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
									   RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
									    RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '022'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
					  --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,							--CD_EMP
											@CD_FILIAL					,							--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS ICMS - CREDITO'		,								--OPERACAO
											''							,							--OPERACAO_DEBITO                					
											0							,							--CD_CNT_RED_CREDITO
											''							,							--CD_CNT_CREDITO
											0							,							--CD_CNT_RED_DEBITO
											''							,							--CD_CNT_DEBITO								
											@RS_DT_MOV					,							--DT_MOV
											@HIST						,							--HIST
											ROUND(@RS_VLR_ICMS,2)		,								--VLR_LANC
											'C'							,							--TP_TRANSA
											0 			,											--RATEIO_CENTRO_CUSTO
											'' 			,											--DS_CENTRO_CUSTO
											0 			,											--CNT_CENTRO_CUSTO
											0 			,											--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											39			,											--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , '' AS CD_BC_LANC;

						------------------------------------------------------------------------------------------------------------------
						--VENDAS DEBITO - Ctb_Cnt_Movimento_Icms_Vendas 
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. ICMS/VENDAS N/ DATA CONF. CUPONS FISCAIS'
						SET @HIST = REPLACE (@HIST,'	',' ')
						INSERT INTO ##CTB_EXP_MOV
						
								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

						  
								SELECT									   
											@RS_CD_EMP					,							--CD_EMP
											@CD_FILIAL					,							--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											''							,							--OPERACAO
											'VENDAS ICMS - DEBITO'		,								--OPERACAO_DEBITO                					
											0							,							--CD_CNT_RED_CREDITO
											''							,							--CD_CNT_CREDITO
											0							,							--CD_CNT_RED_DEBITO
											''							,							--CD_CNT_DEBITO								
											@RS_DT_MOV					,							--DT_MOV
											@HIST						,							--HIST
											ROUND(@RS_VLR_ICMS,2)		,								--VLR_LANC
											'D'							,							--TP_TRANSA
											0 			,											--RATEIO_CENTRO_CUSTO
											'' 			,											--DS_CENTRO_CUSTO
											0 			,											--CNT_CENTRO_CUSTO
											0 			,											--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											49			,											--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
				END

				IF @RS_VLR_BASE_PIS_COFINS > 0
					BEGIN
						SET @RS_VLR_BASE_PIS_COFINS = ROUND(@RS_VLR_BASE_PIS_COFINS,2)
						
						------------------------------------------------------------------------------------------------------------------
						--VENDAS COFINS - Ctb_Cnt_Movimento_Cofins_Recolher 
						------------------------------------------------------------------------------------------------------------------																							
						SET @VLR_COFINS = CAST((@RS_VLR_BASE_PIS_COFINS * (@PERC_COFINS / 100)) AS NUMERIC(18,2))
						SET @VLR_PIS	= CAST((@RS_VLR_BASE_PIS_COFINS * (@PERC_PIS / 100))    AS NUMERIC(18,2))
						
						SET @HIST = 'VALOR REF. COFINS S/VENDAS N/ DATA CONF. CUPONS FISCAIS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR)
						SET @HIST = REPLACE (@HIST,'	',' ')

						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo
				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '023'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV
												
							 (CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
							 						  
								SELECT									   
											@RS_CD_EMP					,							--CD_EMP
											@CD_FILIAL					,						     --CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS COFINS - CREDITO'	,								--OPERACAO
											''							,							--OPERACAO_DEBITO                					
											0							,							--CD_CNT_RED_CREDITO
											''							,							--CD_CNT_CREDITO
											0							,							--CD_CNT_RED_DEBITO
											''							,							--CD_CNT_DEBITO								
											@RS_DT_MOV					,							--DT_MOV
											@HIST						,							--HIST
											ROUND(@VLR_COFINS,2)		,								--VLR_LANC
											'C'							,							--TP_TRANSA
											0 			,											--RATEIO_CENTRO_CUSTO
											'' 			,											--DS_CENTRO_CUSTO
											0 			,											--CNT_CENTRO_CUSTO
											0 			,											--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											40			,											--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;

						------------------------------------------------------------------------------------------------------------------
						--VENDAS COFINS - Ctb_Cnt_Movimento_Cofins_Vendas 
						------------------------------------------------------------------------------------------------------------------																	
						INSERT INTO ##CTB_EXP_MOV  

								    (CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											''							,								--OPERACAO
											'VENDAS COFINS - DEBITO'	,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@VLR_COFINS,2)		,								--VLR_LANC
											'D'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											48			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;

						------------------------------------------------------------------------------------------------------------------
						--VENDAS PIS - Ctb_Cnt_Movimento_Pis_Recolher 
						------------------------------------------------------------------------------------------------------------------																							
						SET @HIST = 'VALOR REF. PIS S/VENDAS N/ DATA CONF. CUPONS FISCAIS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR)
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo
				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '024'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

						         (CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS PIS - CREDITO'		,								--OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@VLR_PIS,2)			,								--VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											41			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;

						------------------------------------------------------------------------------------------------------------------
						--VENDAS PIS - Ctb_Cnt_Movimento_Cofins_Vendas 
						------------------------------------------------------------------------------------------------------------------																	
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											''							,								--OPERACAO
											'VENDAS PIS - DEBITO'		,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@VLR_PIS,2)			,								--VLR_LANC
											'D'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											47			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE					
											 ,'N' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
							  END

					

					IF ROUND(@RS_RECARGA_DINH,2) > 0
					BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NAO FISCAL RECARGA
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. VENDAS RECARGA CELULAR - DINHEIRO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo
				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --=========================================================================================================================== 

						
						INSERT INTO ##CTB_EXP_MOV  

							 (CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS - RECARGA CELULAR - CREDITO'		,					    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECARGA_DINH,2)		,							--VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END

					IF ROUND(@RS_RECARGA_CARTAO,2) > 0
					BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NAO FISCAL RECARGA
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. VENDAS RECARGA CELULAR - CARTAO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS - RECARGA CELULAR - CREDITO'		,					    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECARGA_CARTAO,2)		,							--VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END
					-- Linx Promo No Fiscal


					IF ROUND(@RS_VLR_LINX_PROMO_N_FISCAL,2) > 0
					BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NAO FISCAL VALE PRESENTE LINX PROMO
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. VENDAS VALE PRESENTE LINX PROMO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS LINX PROMO - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_VLR_LINX_PROMO_N_FISCAL,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											0			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END
					-- Fim Linx Promo Fiscal
					
					
					-- Linx Promo Fiscal
					IF ROUND(@RS_VLR_LINX_PROMO_FISCAL,2) > 0
					   BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  FISCAL VALE PRESENTE LINX PROMO
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. VENDAS COM PAGAMENTO VALE PRESENTE LINX PROMO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'VENDAS LINX PROMO - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_VLR_LINX_PROMO_FISCAL,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											56			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END
					-- Fim Linx Promo Fiscal
					
					-- Recebimento de terceiros dinheiro
					IF ROUND(@RS_RECEB_TERCEIROS_DINH,2) > 0
					   BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NO FISCAL - RECEBIMENTOS DE TERCEIROS
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. RECEBIMENTO DE TERCEIROS - DINHEIRO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'RECEB. TERCEIROS - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECEB_TERCEIROS_DINH,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END
					-- Fim  recebimentos terceiros dinheiro

					-- Recebimento de terceiros cartao
					IF ROUND(@RS_RECEB_TERCEIROS_CARTAO,2) > 0
					   BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NO FISCAL - RECEBIMENTOS DE TERCEIROS
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. RECEBIMENTO DE TERCEIROS - CARTAO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'RECEB. TERCEIROS - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECEB_TERCEIROS_CARTAO,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END
					-- Fim  recebimentos terceiros cartao

					----------------------------RPS DINHEIRO------------------------------------

				     IF ROUND(@RS_RECEB_RPS_DINH,2) > 0
					   BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NO FISCAL - RECEBIMENTOS 
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. RECIBO PROVISORIO DE SERVICO - DINHEIRO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'RPS - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECEB_RPS_DINH,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END

					---FIM RPS DINHEIRO

 

				    -------------------------RPS cartao--------------------------

					IF ROUND(@RS_RECEB_RPS_CARTAO,2) > 0
					   BEGIN
						------------------------------------------------------------------------------------------------------------------
						--VENDAS CREDITO -  NO FISCAL - RECEBIMENTOS DE TERCEIROS
						------------------------------------------------------------------------------------------------------------------					
						SET @HIST = 'VALOR REF. RECIBO PROVISORIO DE SERVICO - CARTAO'
						SET @HIST = REPLACE (@HIST,'	',' ')
						  --===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
						  --1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
						  --2 - vendas icms
						  --3 - vendas confins 
						  --4 - vendas pis 
						  --5 - vendas custo				
								
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
										  RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
										   RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
										    RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
						 --===========================================================================================================================
						
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP, CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


								SELECT									   
											@RS_CD_EMP					,								--CD_EMP
											@CD_FILIAL					,								--CD_FILIAL_EXPORT
											@RS_CD_FILIAL				,								--CD_FILIAL
											2 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
											'MOVIMENTO DE VENDAS'		,								--MOVIMENTO			
											'PRS - CREDITO'		,	    --OPERACAO
											''							,								--OPERACAO_DEBITO                					
											0							,								--CD_CNT_RED_CREDITO
											''							,								--CD_CNT_CREDITO
											0							,								--CD_CNT_RED_DEBITO
											''							,								--CD_CNT_DEBITO								
											@RS_DT_MOV					,								--DT_MOV
											@HIST						,								--HIST
											ROUND(@RS_RECEB_RPS_CARTAO,2)		,			    --VLR_LANC
											'C'							,								--TP_TRANSA
											0 			,												--RATEIO_CENTRO_CUSTO
											'' 			,												--DS_CENTRO_CUSTO
											0 			,												--CNT_CENTRO_CUSTO
											0 			,												--VLR_CENTRO_CUSTO											
											'FILIAIS'  ,												--ORIG_CONTA
											52			,												--COD_CONTA
											OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
											 ,'C' AS TIPO_LANCTO
											 , 0 AS CD_EVENTO
											 , 0  AS NR_DP
											 , 0  AS ANO
											 , @NR_CONTROLE AS NR_DOC
											 , 0 AS CD_BC_LANC;
 
					END


					---FIM RPS cartao


																
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP, 
						@RS_CD_FILIAL,						
						@RS_DT_MOV,
						@RS_CD_SC,
						@RS_DS_SC,
						@RS_CD_CTB_CNT_RED,
						@RS_CD_CTB_CNT,
						@RS_VLR_VD,
						@RS_VLR_ICMS,
						@RS_VLR_BASE_PIS_COFINS,
						@RS_RECARGA_DINH,
						@RS_RECARGA_CARTAO,
						@RS_RECARGA_CHQ,
						@RS_VLR_SERVICO,
				        @RS_VLR_LINX_PROMO_N_FISCAL,
						@RS_VLR_LINX_PROMO_FISCAL,
						@RS_RECEB_TERCEIROS_DINH,
						@RS_RECEB_TERCEIROS_CARTAO,
						@RS_RECEB_RPS_DINH,
						@RS_RECEB_RPS_CARTAO		
								
			END

		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
											
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  